#define USE_FOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye : register (c8);
float4 fogData : register (c9);
float4 shadowMapSize : register (c11);
float4x4 shadowProj : register (c16);
float4x4 shadowView : register (c20);

struct VS_OUTPUT
{
   float4 Pos   : POSITION;
#ifdef USEFOG
   float  Fog  : FOG;
#endif   
   float2 Ctr   : TEXCOORD0;
   float2 Left  : TEXCOORD1;
   float2 Right : TEXCOORD2;
   float2 Xtra  : TEXCOORD3;
};

VS_OUTPUT vs11_shadowMapBlur (float4 inPos : POSITION, float2 inTex : TEXCOORD0)
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space (view is the light's view):
  Out.Pos = mul (viewProjMatrix, inPos);

#ifdef USEFOG
  // fog that shadow (in camera space this time)
  float3 eyeVec = worldEye + mul (worldMatrix, inPos);
  Out.Fog = (fogData[1] - (length (eyeVec) * fogData[0]));
#endif   
  
  float4 offset;
  offset.x = 2.0 / 255.0;//shadowMapSize.x;
  offset.y = 2.0 / 255.0;//shadowMapSize.y;
  
  // Propogate texture coordinates
  float3 tex, t = mul (shadowView, inPos);
  tex.xy = mul (shadowProj, t / t.z);
  
  Out.Ctr.x   = tex.x - offset.x;
  Out.Ctr.y   = tex.y - offset.y;
  
  Out.Left.x  = tex.x + offset.x;
  Out.Left.y  = tex.y + offset.y;
  
  Out.Right.x = tex.x + offset.x;
  Out.Right.y = tex.y - offset.y;
  
  Out.Xtra.x = tex.x + offset.x;
  Out.Xtra.y = tex.y + offset.y;
  
  return (Out);
}

